/*
 * Decompiled with CFR 0.152.
 */
package common.control;

import common.control.Calculator2;

public class ConfigurationManager {
    private static final ConfigurationManager INSTANCE = new ConfigurationManager();
    private static final String BACKGROUND_COLOR_PROPERTY = "Background-Color";
    private static final String VERTICAL_MOVE_DELTA_PROPERTY = "Vertical-Move-Delta";
    private static final String VERTICAL_MOVE_PERIOD_PROPERTY = "Vertical-Move-Period";
    private static final String INLINE_EDITING_SUPPORTED_PROPERTY = "Inline-Editing-Supported";
    private int backgroundColor = -1;
    private int verticalMoveDelta = 3;
    private int verticalMovePeriod = 15;
    private boolean inlineEditingSupported = true;

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        return INSTANCE;
    }

    public void init(Calculator2 midlet) {
        String inlineEditingSupportedProperty;
        String verticalMovePeriodProperty;
        String verticalMoveDeltaProperty;
        if (midlet == null) {
            return;
        }
        String backgroundColorProperty = midlet.getAppProperty(BACKGROUND_COLOR_PROPERTY);
        if (backgroundColorProperty != null && backgroundColorProperty.length() == 6) {
            this.backgroundColor = Integer.parseInt(backgroundColorProperty, 16);
        }
        if ((verticalMoveDeltaProperty = midlet.getAppProperty(VERTICAL_MOVE_DELTA_PROPERTY)) != null && verticalMoveDeltaProperty.length() > 0) {
            this.verticalMoveDelta = Integer.parseInt(verticalMoveDeltaProperty);
        }
        if ((verticalMovePeriodProperty = midlet.getAppProperty(VERTICAL_MOVE_PERIOD_PROPERTY)) != null && verticalMovePeriodProperty.length() > 0) {
            this.verticalMovePeriod = Integer.parseInt(verticalMovePeriodProperty);
        }
        if ((inlineEditingSupportedProperty = midlet.getAppProperty(INLINE_EDITING_SUPPORTED_PROPERTY)) != null && inlineEditingSupportedProperty.length() > 0) {
            if (inlineEditingSupportedProperty.equals("false")) {
                this.inlineEditingSupported = false;
            } else if (inlineEditingSupportedProperty.equals("true")) {
                this.inlineEditingSupported = true;
            }
        }
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getVerticalMoveDelta() {
        return this.verticalMoveDelta;
    }

    public int getVerticalMovePeriod() {
        return this.verticalMovePeriod;
    }

    public boolean isInlineEditingSupported() {
        return this.inlineEditingSupported;
    }
}

